% AIC_VAR.M
% Domenico Ferraro
% Duke University
% February 2012

function [mincrit, p] = aic_var(y)

% [mincrit, p] = aic_var(y)
%
%  INPUT:   y  = (t x q) vector-valued time-series
% OUTPUT:   p  = VAR(p) lag-length selected by AIC
%
% Notes: this function calls olsvarc.m

[t,q]=size(y);
maxp=floor(t^(1/3));
T=t-maxp;

crit_aic=zeros(1,maxp);

for p=1:maxp
    [A,SIGMA]=olsvarc(y,p); % VAR(p) w/ constant	
    SIGMA=SIGMA(1:q,1:q);
    crit_aic(p)=log(det(SIGMA))+(p*q^2)*2/T; 
end

[mincrit, p]=min(crit_aic);



